/*
 * Decompiled with CFR 0.152.
 */
package common.control;

import common.control.ConfigurationManager;
import common.control.DisplayManager;
import common.control.SettingsManager;
import common.util.Tools;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import loan.LoanForm;
import scientific.ScientificCanvas;
import standard.StandardCanvas;

public final class Calculator2
extends MIDlet {
    private StandardCanvas standardCalculator = null;
    private ScientificCanvas scientificCalculator = null;
    private LoanForm loanCalculator = null;
    private boolean asynchronousLoadingFinished = false;
    private Alert alert;

    public void closeMIDlet() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public synchronized StandardCanvas getStandardCalculator() {
        if (!this.asynchronousLoadingFinished) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.standardCalculator;
    }

    public synchronized ScientificCanvas getScientificCalculator() {
        if (!this.asynchronousLoadingFinished) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.scientificCalculator;
    }

    public synchronized LoanForm getLoanCalculator() {
        if (!this.asynchronousLoadingFinished) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.loanCalculator;
    }

    protected void startApp() {
        DisplayManager.getInstance().init(Display.getDisplay((MIDlet)this));
        ConfigurationManager.getInstance().init(this);
        SettingsManager.getInstance().init();
        if (SettingsManager.getInstance().getDefaultCalculatorMode() == 0) {
            this.standardCalculator = new StandardCanvas(this);
            DisplayManager.getInstance().push((Displayable)this.standardCalculator);
            SettingsManager.getInstance().setDefaultCalculatorMode(0);
            this.loadCalculatorAsynchronously(1);
        } else if (SettingsManager.getInstance().getDefaultCalculatorMode() == 1) {
            this.scientificCalculator = new ScientificCanvas(this);
            DisplayManager.getInstance().push((Displayable)this.scientificCalculator);
            SettingsManager.getInstance().setDefaultCalculatorMode(1);
            this.loadCalculatorAsynchronously(0);
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean unconditional) {
        SettingsManager.getInstance().close();
    }

    private synchronized void loadCalculatorAsynchronously(final int calculatorId) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void run() {
                if (calculatorId == 0) {
                    Calculator2.this.standardCalculator = new StandardCanvas(Calculator2.this);
                } else if (calculatorId == 1) {
                    Calculator2.this.scientificCalculator = new ScientificCanvas(Calculator2.this);
                }
                Calculator2.this.loanCalculator = new LoanForm(Calculator2.this);
                Calculator2.this.asynchronousLoadingFinished = true;
                Calculator2 calculator2 = Calculator2.this;
                synchronized (calculator2) {
                    ((Object)((Object)Calculator2.this)).notify();
                }
                Tools.getInstance().triggerGarbageCollection();
            }
        };
        thread.start();
    }

    public void showError(String title, String text) {
        Alert alert = new Alert(title, text, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)alert);
    }
}

